<?php
/**
* Tags Block for Advanced User Tagging
*
* @package Advanced User Tagging
*/
class vB_ProfileBlock_UserTagging_UserTags extends vB_ProfileBlock
{
	/**
	* The name of the template to be used for the block
	*
	* @var string
	*/
	var $template_name = 'dbtech_usertag_memberinfo_block_tag';
	
	var $nowrap = true;
	
	var $skip_privacy_check = true;
	
	/**
	* Variables to automatically prepare
	*
	* @var array
	*/
	var $auto_prepare = array();

	/**
	* Sets/Fetches the default options for the block
	*
	*/
	function fetch_default_options()
	{
		$this->option_defaults = array(
			'pagenumber' => 1,
		);
	}

	/**
	* Whether to return an empty wrapper if there is no content in the blocks
	*
	* @return bool
	*/
	function confirm_empty_wrap()
	{
		return false;
	}

	/**
	* Whether or not the block is enabled
	*
	* @return bool
	*/
	function block_is_enabled($id)
	{
		return true;
	}

	/**
	* Prepare any data needed for the output
	*
	* @param	string	The id of the block
	* @param	array	Options specific to the block
	*/
	function prepare_output($id = '', $options = array())
	{
		global $show, $vbphrase;
		
		if (intval($this->registry->versionnumber) == 3)
		{
			$this->nowrap = false;
		}
		
		$bypassCache = false;
		if ($this->profile->userinfo['userid'] == $this->registry->userinfo['userid'] AND $this->registry->userinfo['dbtech_usertag_tagcount'] AND $_REQUEST['tab'] == 'usertags')
		{
			// Reset tag count
			USERTAG::$db->update('user', array('dbtech_usertag_tagcount' => 0), 'WHERE userid = ' . $this->registry->userinfo['userid']);
			$this->registry->userinfo['dbtech_usertag_tagcount'] = 0;
			$bypassCache = true;
		}

		$displayGiven = true;
		
		
		// Shorthands to faciliate easy copypaste
		$pagenumber = $options['pagenumber'];
		$perpage = $options['perpage'];
		$forumIds = USERTAG::forumIds();
		
		$cacheResult = USERTAG_CACHE::read('profile_tag', 'profile.tag.count.' . intval($displayGiven) . '.' . $this->profile->userinfo['userid']);
		if (!is_array($cacheResult) OR $bypassCache)
		{
			// Count number of users
			$count = intval(USERTAG::$db->fetchOne('
				SELECT COUNT(*)
				FROM $dbtech_usertag_tag AS entry
				WHERE (entry.taggedid = ? :includeGiven)
			', array(
				$this->profile->userinfo['userid'],
				':includeGiven' => $displayGiven ? 'OR entry.userid = ' . $this->profile->userinfo['userid'] : ''
			)));

			if ($cacheResult != -1)
			{
				// Write to the cache
				USERTAG_CACHE::write(array('count' => $count), 'profile_tag', 'profile.tag.count.' . intval($displayGiven) . '.' . $this->profile->userinfo['userid']);
			}
		}
		else
		{
			// Set the entry cache
			$count = $cacheResult['count'];
		}
		
		// Ensure every result is as it should be
		sanitize_pageresults($count, $pagenumber, $perpage);
		
		// Find out where to start
		$startat = ($pagenumber - 1) * $perpage;
		
		$pageinfo = array(
			'tab' => $id
		);
		if ($perpage)
		{
			$pageinfo['pp'] = $perpage;
		}

		if (intval($this->registry->versionnumber) > 3)
		{
			$this->block_data['pagenav'] = construct_page_nav(
				$pagenumber,
				$perpage,
				$count,
				'',
				'',
				$id,
				'member',
				$this->profile->userinfo,
				$pageinfo
			);
		}
		else
		{
			$this->block_data['pagenav'] = construct_page_nav(
				$pagenumber,
				$perpage,
				$count,
				'member.php?' . $this->registry->session->vars['sessionurl'] . "u=" . $this->profile->userinfo['userid'] . "&amp;tab=$id" .
				(!empty($perpage) ? "&amp;pp=$perpage" : ""), '', $id
			);
		}

		$cacheResult = USERTAG_CACHE::read('profile_tag', 'profile.tag.results.' . intval($displayGiven) . '.' . $startat . '.' . $perpage . '.' . $this->profile->userinfo['userid']);
		if (!is_array($cacheResult) OR $bypassCache)
		{
			// Fetch users
			$results_q = USERTAG::$db->fetchAll('
				SELECT 
					thread.title AS threadtitle,
					thread.forumid,
					thread.visible,
					tag.dateline,
					tag.threadid,
					user.userid,
					user.username,
					user.usergroupid,
					user.infractiongroupid,
					user.displaygroupid,
					tagged.userid AS taggeduserid,
					tagged.username AS taggedusername,
					tagged.usergroupid AS taggedusergroupid,
					tagged.infractiongroupid AS taggedinfractiongroupid,
					tagged.displaygroupid AS taggeddisplaygroupid
					:vBShop
				FROM $dbtech_usertag_tag AS tag
				LEFT JOIN $thread AS thread ON (thread.threadid = tag.threadid)
				LEFT JOIN $user AS user ON (user.userid = tag.userid)
				LEFT JOIN $user AS tagged ON (tagged.userid = tag.taggedid)
				WHERE (tag.taggedid = :userId :includeGiven)
				ORDER BY dateline DESC
				LIMIT :limitStart, :limitEnd
			', array(
				':userId' 		=> $this->profile->userinfo['userid'],
				':includeGiven' => $displayGiven ? 'OR tag.userid = ' . $this->profile->userinfo['userid'] : '',
				':limitStart' 	=> $startat,
				':limitEnd' 	=> $perpage,
				':vBShop' 		=> ($this->registry->products['dbtech_vbshop'] ? ", user.dbtech_vbshop_purchase, tagged.dbtech_vbshop_purchase AS taggedpurchase" : ''),
			));

			if ($cacheResult != -1)
			{
				// Write to the cache
				USERTAG_CACHE::write($results_q, 'profile_tag', 'profile.tag.results.' . intval($displayGiven) . '.' . $startat . '.' . $perpage . '.' . $this->profile->userinfo['userid']);
			}
		}
		else
		{
			// Set the entry cache
			$results_q = $cacheResult;
		}
		
		// Ensure we got BBCode Parser
		require_once(DIR . '/includes/class_bbcode.php');
		
		// Initialise the parser (use proper BBCode)
		$parser = new vB_BbCodeParser($this->registry, fetch_tag_list());
		
		$results = array();
		foreach ($results_q as $results_r)
		{
			// Ensure we have the proper day selected for the grouping
			$day = vbdate($this->registry->options['dateformat'], $results_r['dateline']);

			// Grab the markup username
			fetch_musername($results_r);
			
			// Store an array of tagged user
			$userinfo = array(
				'userid' 					=> $results_r['taggeduserid'],
				'username'					=> $results_r['taggedusername'],
				'usergroupid' 				=> $results_r['taggedusergroupid'],
				'infractiongroupid' 		=> $results_r['taggedinfractiongroupid'],
				'displaygroupid' 			=> $results_r['taggeddisplaygroupid'],
				'dbtech_vbshop_purchase' 	=> $results_r['taggedpurchase']
			);
			
			// Grab the markup username
			fetch_musername($userinfo);
			
			if (intval($this->registry->versionnumber) == 4)
			{
				// vB4 has SEO URLs
				$link = fetch_seo_url('member', $results_r);
				$link2 = fetch_seo_url('member', $userinfo);
			}
			else
			{
				// vB3 don't
				$link = "member.php?" . $this->registry->session->vars['sessionurl'] . "u=$results_r[userid]";
				$link2 = "member.php?" . $this->registry->session->vars['sessionurl'] . "u=$userinfo[userid]";
			}
			
			// Determine what title to use
			$title = unhtmlspecialchars($results_r['posttitle'] ? $results_r['posttitle'] : $results_r['threadtitle']);
			
			switch ($results_r['visible'])
			{
				case 1:
					// Visible
					if (in_array($results_r['forumid'], $forumIds))
					{
						// Proper forum
						$title = $parser->parse('[thread=' . $results_r['threadid'] . ']' . $title . '[/thread]', 'nonforum');
					}
					else
					{
						// Invisible
						$title = '<i>' . $vbphrase['hidden'] . '</i>';
						$parsePost = false;
					}
					break;

				case 2:
					// Soft deleted
					$title = '<i>' . $vbphrase['deleted_threads'] . '</i>';
					$parsePost = false;
					break;

				default:
					// Moderated deleted
					$title = '<i>' . $vbphrase['moderated_threads'] . '</i>';
					$parsePost = false;
					break;
			}

			$templater = vB_Template::create('dbtech_usertag_result_bit');
				$templater->register('text', construct_phrase($vbphrase['dbtech_usertag_x_tagged_y_in_z'],
					vbdate($this->registry->options['timeformat'], $results_r['dateline']) . ' - <a href="' . $link . '" target="_blank">' . $results_r['musername'] . '</a>',
					'<a href="' . $link2 . '" target="_blank">' . $userinfo['musername'] . '</a>',
					$title
				));
			$results[$day][] = $templater->render();
		}
		
		$resultbits = '';
		foreach ($results as $day => $result)
		{
			$templater = vB_Template::create('dbtech_usertag_result');
				$templater->register('day', $day);
				$templater->register('resultbits', implode('', $result));
			$resultbits .= $templater->render();
		}
		$this->block_data['resultbits'] = $resultbits;		
	}
}

/**
* Mentions Block for Advanced User Tagging
*
* @package Advanced User Tagging
*/
class vB_ProfileBlock_UserTagging_Mentions extends vB_ProfileBlock
{
	/**
	* The name of the template to be used for the block
	*
	* @var string
	*/
	var $template_name = 'dbtech_usertag_memberinfo_block_mention';
	
	var $nowrap = true;
	
	var $skip_privacy_check = true;
	
	/**
	* Variables to automatically prepare
	*
	* @var array
	*/
	var $auto_prepare = array();

	/**
	* Sets/Fetches the default options for the block
	*
	*/
	function fetch_default_options()
	{
		$this->option_defaults = array(
			'pagenumber' => 1,
		);
	}

	/**
	* Whether to return an empty wrapper if there is no content in the blocks
	*
	* @return bool
	*/
	function confirm_empty_wrap()
	{
		return false;
	}

	/**
	* Whether or not the block is enabled
	*
	* @return bool
	*/
	function block_is_enabled($id)
	{
		return true;
	}

	/**
	* Prepare any data needed for the output
	*
	* @param	string	The id of the block
	* @param	array	Options specific to the block
	*/
	function prepare_output($id = '', $options = array())
	{
		global $show, $vbphrase;
		
		if (intval($this->registry->versionnumber) == 3)
		{
			$this->nowrap = false;
		}
		
		$bypassCache = false;
		if ($this->profile->userinfo['userid'] == $this->registry->userinfo['userid'] AND $this->registry->userinfo['dbtech_usertag_mentioncount'] AND $_REQUEST['tab'] == 'mentions')
		{
			// Reset tag count
			USERTAG::$db->update('user', array('dbtech_usertag_mentioncount' => 0), 'WHERE userid = ' . $this->registry->userinfo['userid']);
			$this->registry->userinfo['dbtech_usertag_mentioncount'] = 0;
			$bypassCache = true;
		}

		$displayGiven = true;
		

		// Shorthands to faciliate easy copypaste
		$pagenumber = $options['pagenumber'];
		$perpage = $options['perpage'];
		$forumIds = USERTAG::forumIds();

		$cacheResult = USERTAG_CACHE::read('profile_mention', 'profile.mention.count.' . intval($displayGiven) . '.' . $this->profile->userinfo['userid']);
		if (!is_array($cacheResult) OR $bypassCache)
		{
			// Count number of users
			$count = intval(USERTAG::$db->fetchOne('
				SELECT COUNT(*)
				FROM $dbtech_usertag_mention AS entry
				WHERE (entry.mentionedid = ? :includeGiven)
			', array(
				$this->profile->userinfo['userid'],
				':includeGiven' => $displayGiven ? 'OR entry.userid = ' . $this->profile->userinfo['userid'] : ''
			)));

			if ($cacheResult != -1)
			{
				// Write to the cache
				USERTAG_CACHE::write(array('count' => $count), 'profile_mention', 'profile.mention.count.' . intval($displayGiven) . '.' . $this->profile->userinfo['userid']);
			}
		}
		else
		{
			// Set the entry cache
			$count = $cacheResult['count'];
		}
		
		// Ensure every result is as it should be
		sanitize_pageresults($count, $pagenumber, $perpage);
		
		// Find out where to start
		$startat = ($pagenumber - 1) * $perpage;
		
		
		$pageinfo = array(
			'tab' => $id
		);
		if ($perpage)
		{
			$pageinfo['pp'] = $perpage;
		}

		if (intval($this->registry->versionnumber) > 3)
		{
			$this->block_data['pagenav'] = construct_page_nav(
				$pagenumber,
				$perpage,
				$count,
				'',
				'',
				$id,
				'member',
				$this->profile->userinfo,
				$pageinfo
			);
		}
		else
		{
			$this->block_data['pagenav'] = construct_page_nav(
				$pagenumber,
				$perpage,
				$count,
				'member.php?' . $this->registry->session->vars['sessionurl'] . "u=" . $this->profile->userinfo['userid'] . "&amp;tab=$id" .
				(!empty($perpage) ? "&amp;pp=$perpage" : ""), '', $id
			);
		}
		
		$cacheResult = USERTAG_CACHE::read('profile_mention', 'profile.mention.results.' . intval($displayGiven) . '.' . $startat . '.' . $perpage . '.' . $this->profile->userinfo['userid']);
		if (!is_array($cacheResult) OR $bypassCache)
		{
			$SQL = array();
			$SQL[] = '
				SELECT
					post.pagetext AS message,
					post.title AS posttitle,
					post.visible AS postvisible,
					thread.title AS threadtitle,
					thread.visible,
					thread.forumid,
					mention.dateline,
					mention.postid,
					mention.type,
					user.userid,
					user.username,
					user.usergroupid,
					user.infractiongroupid,
					user.displaygroupid,
					mentioned.userid AS mentioneduserid,
					mentioned.username AS mentionedusername,
					mentioned.usergroupid AS mentionedusergroupid,
					mentioned.infractiongroupid AS mentionedinfractiongroupid,
					mentioned.displaygroupid AS mentioneddisplaygroupid
					:vBShop
				FROM $dbtech_usertag_mention AS mention
				LEFT JOIN $post AS post ON (post.postid = mention.postid)
				LEFT JOIN $thread AS thread ON (thread.threadid = post.threadid)
				LEFT JOIN $user AS user ON (user.userid = mention.userid)
				LEFT JOIN $user AS mentioned ON (mentioned.userid = mention.mentionedid)
				WHERE (mention.mentionedid = :userId :includeGiven)
					AND mention.type = \'post\'
				ORDER BY dateline DESC
				LIMIT :limitStart, :limitEnd
			';

			if ($this->registry->products['vbblog'])
			{
				$SQL[] = '
					SELECT 
						blog_text.pagetext AS message,
						blog_text.title AS posttitle,
						IF(blog_text.state = \'visible\', 1, 0) AS postvisible,
						blog.title AS threadtitle,
						IF(blog.state = \'visible\', 1, 0) AS visible,
						0 AS forumid,
						mention.dateline,
						mention.postid,
						mention.type,
						user.userid,
						user.username,
						user.usergroupid,
						user.infractiongroupid,
						user.displaygroupid,
						mentioned.userid AS mentioneduserid,
						mentioned.username AS mentionedusername,
						mentioned.usergroupid AS mentionedusergroupid,
						mentioned.infractiongroupid AS mentionedinfractiongroupid,
						mentioned.displaygroupid AS mentioneddisplaygroupid
						:vBShop
					FROM $dbtech_usertag_mention AS mention
					LEFT JOIN $blog_text AS blog_text ON (blog_text.blogtextid = mention.postid)
					LEFT JOIN $blog AS blog ON (blog.blogid = blog_text.blogid)
					LEFT JOIN $user AS user ON (user.userid = mention.userid)
					LEFT JOIN $user AS mentioned ON (mentioned.userid = mention.mentionedid)
					WHERE (mention.mentionedid = :userId :includeGiven)
						AND mention.type = \'blog\'
					ORDER BY dateline DESC
					LIMIT :limitStart, :limitEnd
				';
			}

			// Fetch users
			$results_q = USERTAG::$db->fetchAll('
				(
				' . implode(' ) UNION ALL ( ', $SQL) . '
				)
				ORDER BY dateline DESC
			', array(
				':userId' 		=> $this->profile->userinfo['userid'],
				':includeGiven' => $displayGiven ? 'OR mention.userid = ' . $this->profile->userinfo['userid'] : '',
				':limitStart' 	=> $startat,
				':limitEnd' 	=> $perpage,
				':vBShop' 		=> ($this->registry->products['dbtech_vbshop'] ? ", user.dbtech_vbshop_purchase, mentioned.dbtech_vbshop_purchase AS mentionedpurchase" : ''),
			));

			if ($cacheResult != -1)
			{
				// Write to the cache
				USERTAG_CACHE::write($results_q, 'profile_mention', 'profile.mention.results.' . intval($displayGiven) . '.' . $startat . '.' . $perpage . '.' . $this->profile->userinfo['userid']);
			}
		}
		else
		{
			// Set the entry cache
			$results_q = $cacheResult;
		}

		// Ensure we got BBCode Parser
		require_once(DIR . '/includes/class_bbcode.php');
		
		// Initialise the parser (use proper BBCode)
		$parser = new vB_BbCodeParser($this->registry, fetch_tag_list());
		
		$results = array();
		foreach ($results_q as $results_r)
		{
			// Ensure we have the proper day selected for the grouping
			$day = vbdate($this->registry->options['dateformat'], $results_r['dateline']);

			// Grab the markup username
			fetch_musername($results_r);
			
			// Store an array of mentioned user
			$userinfo = array(
				'userid' 			=> $results_r['mentioneduserid'],
				'username'			=> $results_r['mentionedusername'],
				'usergroupid' 		=> $results_r['mentionedusergroupid'],
				'infractiongroupid' => $results_r['mentionedinfractiongroupid'],
				'displaygroupid' 	=> $results_r['mentioneddisplaygroupid']
			);
			
			// Grab the markup username
			fetch_musername($userinfo);
			
			if (intval($this->registry->versionnumber) == 4)
			{
				// vB4 have SEO URLs
				$link = fetch_seo_url('member', $results_r);
				$link2 = fetch_seo_url('member', $userinfo);
			}
			else
			{
				// vB3 don't
				$link = "member.php?" . $this->registry->session->vars['sessionurl'] . "u=$results_r[userid]";
				$link2 = "member.php?" . $this->registry->session->vars['sessionurl'] . "u=$userinfo[userid]";
			}
			
			// Determine what title to use
			$title = unhtmlspecialchars($results_r['posttitle'] ? $results_r['posttitle'] : $results_r['threadtitle']);

			$parsePost = true;
			if ($results_r['postvisible'] == 1 AND $results_r['visible'] == 1)
			{
				switch ($results_r['type'])
				{
					case 'post':
						if (in_array($results_r['forumid'], $forumIds))
						{
							// Proper forum
							$title = $parser->parse('[post=' . $results_r['postid'] . ']' . $title . '[/post]', 'nonforum');
						}
						else
						{
							// Invisible
							$title = '<i>' . $vbphrase['hidden'] . '</i>';
							$parsePost = false;
						}
						break;

					case 'blog':
						// Blogs are always good
						$title = '<a href="blog.php?' . $vbulletin->session->vars['sessionurl'] . 'bt=' . $results_r['postid'] . '">' . $title . '</a>';
						break;
				}
			}
			else
			{
				// Invisible
				$title = '<i>' . $vbphrase['deleted_posts'] . '</i>';
				$parsePost = false;
			}
			
			// Ensure this is set
			$this->registry->options['dbtech_usertag_postpreview_charlimit'] = (!isset($this->registry->options['dbtech_usertag_postpreview_charlimit']) ? 20 : $this->registry->options['dbtech_usertag_postpreview_charlimit']);
			
			$message = $message_orig = $prefix = $suffix = '';
			if ($parsePost)
			{
				// Get rid of BBCode so we're left with the username and :
				$message = $message_orig = strip_bbcode($results_r['message'], false, false, false);
				
				if (strtoupper($userinfo['username']))
				{
					$start = $origstart = strpos(strtoupper($message), strtoupper($userinfo['username']));
				}
				else
				{
					$start = $origstart = 0;
				}
				
				if ($start >= $this->registry->options['dbtech_usertag_postpreview_charlimit'])
				{
					// Get the new start pos
					$prefix = '...';
					$start -= $this->registry->options['dbtech_usertag_postpreview_charlimit'];
				}
				else
				{
					$prefix = '';
					$start = 0;
				}
				
				$remaining = substr($message, ($origstart + strlen($userinfo['username'] . ':')));
				
				// - ($this->registry->options['dbtech_usertag_postpreview_charlimit'] * 2)
				if (strlen($remaining) > $this->registry->options['dbtech_usertag_postpreview_charlimit'])
				{
					// Get the new end pos
					$suffix = '...';
					$end = $this->registry->options['dbtech_usertag_postpreview_charlimit'] - strlen($remaining);
					$message = substr($message, $start, $end);
				}
				else
				{
					$suffix = '';
					$end = 0;
					$message = substr($message, $start);
				}
			}
			else
			{
				// Get rid of the message
				$message = $prefix = $suffix = '';
			}
			
			// Store a cache
			$templater = vB_Template::create('dbtech_usertag_result_bit');
				$templater->register('text', construct_phrase($vbphrase['dbtech_usertag_x_mentioned_y_in_z'],
					vbdate($this->registry->options['timeformat'], $results_r['dateline']) . ' - <a href="' . $link . '" target="_blank">' . $results_r['musername'] . '</a>',
					'<a href="' . $link2 . '" target="_blank">' . $userinfo['musername'] . '</a>',
					$title
				) . '<br /><div style="padding-left: 15px;">' . $prefix . htmlspecialchars_uni($message) . $suffix . '</div>');
			$results[$day][] = $templater->render();
		}
		
		
		$resultbits = '';
		foreach ($results as $day => $result)
		{
			$templater = vB_Template::create('dbtech_usertag_result');
				$templater->register('day', $day);
				$templater->register('resultbits', implode('', $result));
			$resultbits .= $templater->render();
		}
		$this->block_data['resultbits'] = $resultbits;		
		
		// Make sure we can check the options
		//$this->block_data['options'] = $options;
	}
}

/**
* Quotes Block for Advanced User Tagging
*
* @package Advanced User Tagging
*/
class vB_ProfileBlock_UserTagging_Quotes extends vB_ProfileBlock
{
	/**
	* The name of the template to be used for the block
	*
	* @var string
	*/
	var $template_name = 'dbtech_usertag_memberinfo_block_quote';
	
	var $nowrap = true;
	
	var $skip_privacy_check = true;
	
	/**
	* Variables to automatically prepare
	*
	* @var array
	*/
	var $auto_prepare = array();

	/**
	* Sets/Fetches the default options for the block
	*
	*/
	function fetch_default_options()
	{
		$this->option_defaults = array(
			'pagenumber' => 1,
		);
	}

	/**
	* Whether to return an empty wrapper if there is no content in the blocks
	*
	* @return bool
	*/
	function confirm_empty_wrap()
	{
		return false;
	}

	/**
	* Whether or not the block is enabled
	*
	* @return bool
	*/
	function block_is_enabled($id)
	{
		return true;
	}

	/**
	* Prepare any data needed for the output
	*
	* @param	string	The id of the block
	* @param	array	Options specific to the block
	*/
	function prepare_output($id = '', $options = array())
	{
		global $show, $vbphrase;
		
		if (intval($this->registry->versionnumber) == 3)
		{
			$this->nowrap = false;
		}
		
		$bypassCache = false;
		if ($this->profile->userinfo['userid'] == $this->registry->userinfo['userid'] AND $this->registry->userinfo['dbtech_usertag_quotecount'] AND $_REQUEST['tab'] == 'quotes')
		{
			// Reset tag count
			USERTAG::$db->update('user', array('dbtech_usertag_quotecount' => 0), 'WHERE userid = ' . $this->registry->userinfo['userid']);
			$this->registry->userinfo['dbtech_usertag_quotecount'] = 0;
			$bypassCache = true;
		}

		$displayGiven = true;
		

		// Shorthands to faciliate easy copypaste
		$pagenumber = $options['pagenumber'];
		$perpage = $options['perpage'];
		$forumIds = USERTAG::forumIds();
		
		$cacheResult = USERTAG_CACHE::read('profile_quote', 'profile.quote.count.' . intval($displayGiven) . '.' . $this->profile->userinfo['userid']);
		if (!is_array($cacheResult) OR $bypassCache)
		{
			// Count number of users
			$count = intval(USERTAG::$db->fetchOne('
				SELECT COUNT(*)
				FROM $dbtech_usertag_quote AS entry
				WHERE (entry.quotedid = ? :includeGiven)
			', array(
				$this->profile->userinfo['userid'],
				':includeGiven' => $displayGiven ? 'OR entry.userid = ' . $this->profile->userinfo['userid'] : ''
			)));

			if ($cacheResult != -1)
			{
				// Write to the cache
				USERTAG_CACHE::write(array('count' => $count), 'profile_quote', 'profile.quote.count.' . intval($displayGiven) . '.' . $this->profile->userinfo['userid']);
			}
		}
		else
		{
			// Set the entry cache
			$count = $cacheResult['count'];
		}
		
		// Ensure every result is as it should be
		sanitize_pageresults($count, $pagenumber, $perpage);
		
		// Find out where to start
		$startat = ($pagenumber - 1) * $perpage;
		
		$pageinfo = array(
			'tab' => $id
		);
		if ($perpage)
		{
			$pageinfo['pp'] = $perpage;
		}

		if (intval($this->registry->versionnumber) > 3)
		{
			$this->block_data['pagenav'] = construct_page_nav(
				$pagenumber,
				$perpage,
				$count,
				'',
				'',
				$id,
				'member',
				$this->profile->userinfo,
				$pageinfo
			);
		}
		else
		{
			$this->block_data['pagenav'] = construct_page_nav(
				$pagenumber,
				$perpage,
				$count,
				'member.php?' . $this->registry->session->vars['sessionurl'] . "u=" . $this->profile->userinfo['userid'] . "&amp;tab=$id" .
				(!empty($perpage) ? "&amp;pp=$perpage" : ""), '', $id
			);
		}
		
		$cacheResult = USERTAG_CACHE::read('profile_quote', 'profile.quote.results.' . intval($displayGiven) . '.' . $startat . '.' . $perpage . '.' . $this->profile->userinfo['userid']);
		if (!is_array($cacheResult) OR $bypassCache)
		{
			$SQL = array();
			$SQL[] = '
				SELECT
					post.pagetext AS message,
					post.title AS posttitle,
					post.visible AS postvisible,
					thread.title AS threadtitle,
					thread.visible,
					thread.forumid,
					quote.dateline,
					quote.postid,
					quote.type,
					user.userid,
					user.username,
					user.usergroupid,
					user.infractiongroupid,
					user.displaygroupid,
					quoted.userid AS quoteduserid,
					quoted.username AS quotedusername,
					quoted.usergroupid AS quotedusergroupid,
					quoted.infractiongroupid AS quotedinfractiongroupid,
					quoted.displaygroupid AS quoteddisplaygroupid
					:vBShop
				FROM $dbtech_usertag_quote AS quote
				LEFT JOIN $post AS post ON (post.postid = quote.postid)
				LEFT JOIN $thread AS thread ON (thread.threadid = post.threadid)
				LEFT JOIN $user AS user ON (user.userid = quote.userid)
				LEFT JOIN $user AS quoted ON (quoted.userid = quote.quotedid)
				WHERE (quote.quotedid = :userId :includeGiven)
					AND quote.type = \'post\'
				ORDER BY dateline DESC
				LIMIT :limitStart, :limitEnd
			';

			if ($this->registry->products['vbblog'])
			{
				$SQL[] = '
					SELECT 
						blog_text.pagetext AS message,
						blog_text.title AS posttitle,
						IF(blog_text.state = \'visible\', 1, 0) AS postvisible,
						blog.title AS threadtitle,
						IF(blog.state = \'visible\', 1, 0) AS visible,
						-1 AS forumid,
						quote.dateline,
						quote.postid,
						quote.type,
						user.userid,
						user.username,
						user.usergroupid,
						user.infractiongroupid,
						user.displaygroupid,
						quoted.userid AS quoteduserid,
						quoted.username AS quotedusername,
						quoted.usergroupid AS quotedusergroupid,
						quoted.infractiongroupid AS quotedinfractiongroupid,
						quoted.displaygroupid AS quoteddisplaygroupid
						:vBShop
					FROM $dbtech_usertag_quote AS quote
					LEFT JOIN $blog_text AS blog_text ON (blog_text.blogtextid = quote.postid)
					LEFT JOIN $blog AS blog ON (blog.blogid = blog_text.blogid)
					LEFT JOIN $user AS user ON (user.userid = quote.userid)
					LEFT JOIN $user AS quoted ON (quoted.userid = quote.quotedid)
					WHERE (quote.quotedid = :userId :includeGiven)
						AND quote.type = \'blog\'
					ORDER BY dateline DESC
					LIMIT :limitStart, :limitEnd
				';
			}

			// Fetch users
			$results_q = USERTAG::$db->fetchAll('
				(
				' . implode(' ) UNION ALL ( ', $SQL) . '
				)
				ORDER BY dateline DESC
			', array(
				':userId' 		=> $this->profile->userinfo['userid'],
				':includeGiven' => $displayGiven ? 'OR quote.userid = ' . $this->profile->userinfo['userid'] : '',
				':limitStart' 	=> $startat,
				':limitEnd' 	=> $perpage,
				':vBShop' 		=> ($this->registry->products['dbtech_vbshop'] ? ", user.dbtech_vbshop_purchase, quoted.dbtech_vbshop_purchase AS quotedpurchase" : ''),
			));

			if ($cacheResult != -1)
			{
				// Write to the cache
				USERTAG_CACHE::write($results_q, 'profile_quote', 'profile.quote.results.' . intval($displayGiven) . '.' . $startat . '.' . $perpage . '.' . $this->profile->userinfo['userid']);
			}
		}
		else
		{
			// Set the entry cache
			$results_q = $cacheResult;
		}	

		// Ensure we got BBCode Parser
		require_once(DIR . '/includes/class_bbcode.php');
		
		// Initialise the parser (use proper BBCode)
		$parser = new vB_BbCodeParser($this->registry, fetch_tag_list());
		
		$results = array();
		foreach ($results_q as $results_r)
		{
			// Ensure we have the proper day selected for the grouping
			$day = vbdate($this->registry->options['dateformat'], $results_r['dateline']);

			// Grab the markup username
			fetch_musername($results_r);
			
			// Store an array of quoted user
			$userinfo = array(
				'userid' 					=> $results_r['quoteduserid'],
				'username'					=> $results_r['quotedusername'],
				'usergroupid' 				=> $results_r['quotedusergroupid'],
				'infractiongroupid' 		=> $results_r['quotedinfractiongroupid'],
				'displaygroupid' 			=> $results_r['quoteddisplaygroupid'],
				'dbtech_vbshop_purchase' 	=> $results_r['quotedpurchase']
			);
			
			// Grab the markup username
			fetch_musername($userinfo);
			
			if (intval($this->registry->versionnumber) == 4)
			{
				// vB4 have SEO URLs
				$link = fetch_seo_url('member', $results_r);
				$link2 = fetch_seo_url('member', $userinfo);
			}
			else
			{
				// vB3 don't
				$link = "member.php?" . $this->registry->session->vars['sessionurl'] . "u=$results_r[userid]";
				$link2 = "member.php?" . $this->registry->session->vars['sessionurl'] . "u=$userinfo[userid]";
			}
			
			// Determine what title to use
			$title = unhtmlspecialchars($results_r['posttitle'] ? $results_r['posttitle'] : $results_r['threadtitle']);

			$parsePost = true;
			if ($results_r['postvisible'] == 1 AND $results_r['visible'] == 1)
			{
				switch ($results_r['type'])
				{
					case 'post':
						if (in_array($results_r['forumid'], $forumIds))
						{
							// Proper forum
							$title = $parser->parse('[post=' . $results_r['postid'] . ']' . $title . '[/post]', 'nonforum');
						}
						else
						{
							// Invisible
							$title = '<i>' . $vbphrase['hidden'] . '</i>';
							$parsePost = false;
						}
						break;

					case 'blog':
						// Blogs are always good
						$title = '<a href="blog.php?' . $vbulletin->session->vars['sessionurl'] . 'bt=' . $results_r['postid'] . '">' . $title . '</a>';
						break;
				}
			}
			else
			{
				// Invisible
				$title = '<i>' . $vbphrase['deleted_posts'] . '</i>';
				$parsePost = false;
			}
			
			// Ensure this is set
			$this->registry->options['dbtech_usertag_postpreview_charlimit'] = (!isset($this->registry->options['dbtech_usertag_postpreview_charlimit']) ? 20 : $this->registry->options['dbtech_usertag_postpreview_charlimit']);
			
			$message = $message_orig = $prefix = $suffix = '';
			if ($parsePost)
			{
				// Get rid of BBCode so we're left with the username and :
				$message = $message_orig = strip_bbcode($results_r['message'], false, false, false);
				
				if (strtoupper($userinfo['username']))
				{
					$start = $origstart = strpos(strtoupper($message), strtoupper($userinfo['username']));
				}
				else
				{
					$start = $origstart = 0;
				}
				
				if ($start >= $this->registry->options['dbtech_usertag_postpreview_charlimit'])
				{
					// Get the new start pos
					$prefix = '...';
					$start -= $this->registry->options['dbtech_usertag_postpreview_charlimit'];
				}
				else
				{
					$prefix = '';
					$start = 0;
				}
				
				$remaining = substr($message, ($origstart + strlen($userinfo['username'] . ':')));
				
				// - ($this->registry->options['dbtech_usertag_postpreview_charlimit'] * 2)
				if (strlen($remaining) > $this->registry->options['dbtech_usertag_postpreview_charlimit'])
				{
					// Get the new end pos
					$suffix = '...';
					$end = $this->registry->options['dbtech_usertag_postpreview_charlimit'] - strlen($remaining);
					$message = substr($message, $start, $end);
				}
				else
				{
					$suffix = '';
					$end = 0;
					$message = substr($message, $start);
				}
			}
			else
			{
				// Get rid of the message
				$message = $prefix = $suffix = '';
			}

			// Store a cache
			$templater = vB_Template::create('dbtech_usertag_result_bit');
				$templater->register('text', construct_phrase($vbphrase['dbtech_usertag_x_quoted_y_in_z'],
					vbdate($this->registry->options['timeformat'], $results_r['dateline']) . ' - <a href="' . $link . '" target="_blank">' . $results_r['musername'] . '</a>',
					'<a href="' . $link2 . '" target="_blank">' . $userinfo['musername'] . '</a>',
					$title
				) . '<br /><div style="padding-left: 15px;">' . $prefix . htmlspecialchars_uni($message) . $suffix . '</div>');
			$results[$day][] = $templater->render();
		}
		
		$resultbits = '';
		foreach ($results as $day => $result)
		{
			$templater = vB_Template::create('dbtech_usertag_result');
				$templater->register('day', $day);
				$templater->register('resultbits', implode('', $result));
			$resultbits .= $templater->render();
		}
		$this->block_data['resultbits'] = $resultbits;		
		
		// Make sure we can check the options
		//$this->block_data['options'] = $options;
	}
}
?>